s        3    -4                                         tga1240     TTi TGA1240 Arbitrary Generator               N     Instrument Name: Thurlby Thandar TGA1240 series 
                  Arbitrary Generators.

 Description:     This instrument module provides
                  programming support for the
                  TGA1240 series. The instruments 
                  supported are:
                           TGA1241    one channel
                           TGA1242    two channels
                           TGA1244    four channels
                  The module is divided into the 
                  following functions:

 Functions/Classes:

 (1) Initialize
     Initialize the instrument and optionally
     interrogate the ID and set to the specified
     reset conditions.

 (2) Configure...
     This class of functions configures the main
     generator and allows access
     to the Modulation capabilities of the instrument.
        (1) Waveform
            Set up such parameters as output waveform,
            frequency and amplitude.
        (2) Std Waveform setup...
            This class of functions allows setting the
            parameters for std waveforms
            (1) Pulse setup
            (2) Pulse train setup
        (3) Arb Waveform setup...
            This class of functions allows setting of arb 
            waveforms
            (1) Arb info
            (2) Create new arb
            (3) Modify arb
            (4) Edit arb
        (4) Mode setup
            Allows setup an selection of the various modes
        (5) Connector setup
            Configure and control trigrer input and sync outputs
            etc.
        (6) Sweep setup
            Configures and controls the sweep operation
        (7) Sequence setup
            configure and control waveform sequencing. 
        (8) Modulation
            Colfigure and control AM and SCM
        (9) Sum setup
            Configure and control signal summing
       (10) Sum setup
            Configure and control inter channel phase locking
       (11) Set Status
            Configure the IEEE 488.2 status
            reporting capabilities of the Instrument.
 (3) Data functions
     This class of functions allow arb waveforms to be exchanged
     between the controller and the instrument
         (1) Read arb data
             Returns data from an arb to the controller
         (2) Write arb data
             Accepts data from the controller and stores it in 
             the specified arb waveform
 (4) Local Storage
     Executes the Store and Recall commands.
 (5) Get Status
     Returns the current value of the specified
     IEEE 488.2 status byte.
 (6) Miscellaneous
     This class of functions allows access to
     additional remote control commands
     which are not available elsewhere in this
     driver. Also included are file operations.
        (1) Send Command String
        (2) Get Response String
        (3) File Operations
 (7) Close
     Take the instrument offline.          Description: This class of functions configures
               the main generator and allows
               access to the Modulation
               capabilities of the instrument

        (1) Waveform
            Set up such parameters as output waveform,
            frequency and amplitude.
        (2) Std Waveform setup...
            This class of functions allows setting the
            parameters for std waveforms
            (1) Pulse setup
            (2) Pulse train setup
        (3) Arb Waveform setup...
            This class of functions allows setting of arb 
            waveforms
            (1) Arb info
            (2) Create new arb
            (3) Modify arb
            (4) Edit arb
        (4) Mode setup
            Allows setup an selection of the various modes
        (5) Connector setup
            Configure and control trigrer input and sync outputs
            etc.
        (6) Sweep setup
            Configures and controls the sweep operation
        (7) Sequence setup
            configure and control waveform sequencing. 
        (8) Modulation
            Colfigure and control AM and SCM
        (9) Sum setup
            Configure and control signal summing
       (10) Sum setup
            Configure and control inter channel phase locking
       (11) Set Status
            Configure the IEEE 488.2 status
            reporting capabilities of the Instrument.
           Description:   This class of functions allows setting the
                 parameters for std waveforms
            
            (1) Pulse setup
            (2) Pulse train setup
           Description:  This class of functions allows setting of arb 
                waveforms

            (1) Arb info
            (2) Create new arb
            (3) Modify arb
            (4) Edit arb
    x      Description:    This class of functions allow arb waveforms 
                  to be exchanged between the controller and 
                  the instrument

         (1) Read arb data
             Returns data from an arb to the controller
         (2) Write arb data
             Accepts data from the controller and stores it in 
             the specified arb waveform
    Y      Description:  This class of functions allows
                access to additional remote
                control commands which are not
                available elsewhere in this
                driver. Also included are file
                operations.

     (1) Send Command String
     (2) Get Response String
     (3) File Operations


    5    
 Description:   Initializes the instrument in the
                following ways:

                - opens the instrument and sets
                  its GPIB address to the speci-
                  fied value

                - optionally performs an
                  identification query on the
                  instrument

                - optionally sets the instrument
                  to a default configuration

                - returns an instrument ID which
                  is used to identify the
                  instrument in subsequent calls.    G    
 Description:   Specifies the address on the
                GPIB to be used to communicate
                with the instrument.  This value
                must correspond to the current
                internal setting of the
                instrument.

 Variable Type: Integer

 Valid Range:   0 to 30

 Default Value: 5        
 Description:   Returns an Instrument ID that is
                used in all subsequent function
                calls to select the instrument at
                the Address specified.

                If more than one instrument of the
                same type is used, this value will
                be used to differentiate between
                them. The first instrument
                initialized will be assigned an
                Instrument ID of 1.

 Variable Type: Integer        
 Description:   Specifies if an ID Query is sent
                to the instrument during the
                initialization procedure.

 Variable Type: Integer

 Valid Range:   1 = Yes
                0 = No

 Default Value: 1 - Yes

 NOTE:  Under normal circumstances the ID Query
        insures that the instrument initialized
        over the GPIB is the type supported by
        this driver. However circumstances may
        arise where it is undesirable to send an
        ID Query to the instrument. In those
        cases; set this control to Skip Query
        and this function will initialize the
        GPIB and the Command arrays in the driver,
        without doing an ID Query.    t    
 Description:   Specifies if the instrument is to
                be reset during the initialization
                procedure.

 Variable Type: Integer

 Valid Range:   0 = No Reset
                1 = Reset device

 Default Value: 1 = Reset

 NOTE: If you do not want the instrument reset.
       Set this control to No Reset while
       initializing the instrument.    _    
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   GPIB Address out of range
       -2   ID Query out of range
       -3   Reset Device out of range

      220   Unable to open instrument
      221   Unable to close instrument
      223   Instrument identification query failed
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      240   Instrument timed out     - g           Address                           ] -          Instrument ID                     Q  `          ID Query                           $          Reset Device                                Error                                                                       6                                            5    	           Do Query 1 Skip Query 0   Yes 1 No 0    	            )Instrument driver version 1.0 March 2000    Copyright (c) TTi Ltd.        
 Description:   Sets up Function, Frequency,
                Peak-Peak Output level, 
                output status, DC Offset,
                and load impedance for the 
                specified output channel.    	    
 Description:   Specifies the output waveform
                function.

 Variable Type: Integer

 Valid Range:   0 = Sine
                1 = Square
                2 = Triangle
                3 = DC
                4 = Positive Ramp
                5 = Negative Ramp
                6 = Cosine
                7 = Haversine 
                8 = Havercos
                9 = Sync
               10 = Pulse
               11 = Pulse train
               12 = ARB
               13 = Sequence

 Default Value: 0 - Sine         
 Description:   The output Frequency or Period expressed in
                Hz or seconds.

 Variable Type: double

 Valid Range:   1e-4 to maximum value for the selected
                Function (0.1mHz to 16MHz max)

 Default Value: 10kHz         
 Description:   Turns the Main output on or off.

 Variable Type: Integer

 Valid Range:   1 = On
                0 = Off

 Default Value: 0 - Off         
 Description:   Sets the output sense to NORMAL or
                INVERTed.

 Variable Type: Integer

 Valid Range:   1 = Invert
                0 = Normal

 Default Value: 0 (normal)        
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Function value out of range
       -3   Output value out of range
       -4   Frequency value out of range
       -5   DC offset value out of range
       -6   Freq/per value out of range
       -8   Zout value out of range
       -9   Sense value out of range
       -10  Channel value out of range

      100 to 199 are instrument execution errors
            see the instrument instruction manual
            for details.

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out
         
 Description:   Sets the output Offset voltage in Volts

 Variable Type: double

 Valid Range:   -10 to +10

 Default Value: 0.0         
 Description:   Set the output load.

 Variable Type: Integer

 Valid Range:   0 =  HiZ
                1 =  50 Ohms
                2 = 600 Ohms

 Default Value: 0 (HiZ)    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         
 Description:   Sets the output level in Volts peak-peak.

 Variable Type: double

 Valid Range:   10mV to 20V

 Default Value: 2.0         
 Description:   Specifies the arb waveform name to
                use when the function is set to Arb.

 Variable Type: String

 Valid Range:   Must be an existing arb waveform.

 Default Value: "wv01"

    .    
 Description:   Specifies the data type for the
                Frequency/Period control..

 Variable Type: Integer

 Valid Range:   0 = Waveform frequency
                1 = Waveform period
                2 = Sample frequency
                3 = Sample period

 Default Value: 0 - Waveform period    (    
 Description:   Selects the channel to configure.

 Variable Type: Integer

 Valid Range:   0 =  CH1
                1 =  CH2
                2 =  CH3
                3 =  CH4

 Default Value: 0 - CH1

 Note. The instrument will ganerate an error if the selected
       channel is not present.    $            Function                          & r          Frequency/Period                  ' r          Output                            ( r          Sense                             )B          Error                             ,G          DC Offset (V)                     , rr         Load                              - 
           Instrument ID                     / 8         Amplitude (Vpp)                   0W           Arb wfm name                      1.  	        Freq/Per                          2d   
        Channel                                       Sine 0 Square 1 Triangle 2 DC 3 Pos Ramp 4 Neg Ramp 5 Cosine 6 Haversine 7 Havercos 8 Sync 9 Pulse 10 Pulse Train 11 Arb 12 Sequence 13    10000    On 1 Off 0    Invert 1 Normal 0    	            0.0               HiZ 0 50 Ohm 1 600 Ohm 2    1    2.0    "wv01"               @Waveform freq 0 Waveform period 1 Sample freq 2 Sample period 3               1 0 2 1 3 2 4 3    r      
  Description:    Setup the pulse parameters for the specified             
                  output channel.         
 Description:   The pulse Period expressed in seconds.

 Variable Type: double

 Valid Range:   100e-9 to 100

 Default Value: 100e-6         
 Description:   The Pulse width expressed in seconds.

 Variable Type: double

 Valid Range:   25e-9 to 99.99

 Default Value: 50e-6         
 Description:   The Pulse delay expressed  seconds.

 Variable Type: double

 Valid Range:   -99.99 to +99.99

 Default Value: 0    \    
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Period value out of range
       -3   Width value out of range
       -4   Delay value out of range
       -10  Channel value out of range

      100 to 199 are instrument execution errors
            see the instrument instruction manual
            for details.

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out
    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    (    
 Description:   Selects the channel to configure.

 Variable Type: Integer

 Valid Range:   0 =  CH1
                1 =  CH2
                2 =  CH3
                3 =  CH4

 Default Value: 0 - CH1

 Note. The instrument will ganerate an error if the selected
       channel is not present.    8 5          Pulse Period                      8 r          Pulse Width                       9+           Pulse Delay                       9 i         Error                             <  )           Instrument ID                     >\ 3 T         Channel                            100e-6    50e-6    0    	            1               1 0 2 1 3 2 4 3    l      
  Description:    Setup the pulse train parameters for the 
                  specified output channel.    (    
 Description:   Selects the channel to configure.

 Variable Type: Integer

 Valid Range:   0 =  CH1
                1 =  CH2
                2 =  CH3
                3 =  CH4

 Default Value: 0 - CH1

 Note. The instrument will ganerate an error if the selected
       channel is not present.         
 Description:   The pulse train period expressed in seconds.

 Variable Type: double

 Valid Range:   100e-9 to 100

 Default Value: 100e-6         
 Description:   The Pulse width expressed in seconds.

 Variable Type: double

 Valid Range:   25e-9 to 99.99

 Default Value: 50e-6         
 Description:   The Pulse delay expressed  seconds.

 Variable Type: double

 Valid Range:   -99.99 to +99.99

 Default Value: 0    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.        
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Period value out of range
       -3   Width value out of range
       -4   Delay value out of range
       -5   Pulse number value out of range
       -6   Baseline value out of range
       -7   Pulse level value out of range
       -8   Number of pulses out of range  
      -10   Channel value out of range

      100 to 199 are instrument execution errors
            see the instrument instruction manual
            for details.

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out
         
 Description:   The pulse train baseline position expressed 
                in Volts.

 Variable Type: double

 Valid Range:   -5 to +5

 Default Value: 0         
 Description:   The pulse Period expressed in seconds.

 Variable Type: double

 Valid Range:   10e6 to 100

 Default Value: 100e-6         
 Description:   The pulse number to receive the values.

 Variable Type: Integer

 Valid Range:   1 to 10

 Default Value: 1

         
 Description:   The number of pulses in the pulse train.

 Variable Type: integer

 Valid Range:   1 to 10

 Default Value: 1    t    
 Description:   Specifies if the pulse train should be built
                immediately after the new values are installed.

 Variable Type: Integer

 Valid Range:   0 = No
                1 = Yes

 Default Value: 0 - No

Note: This parameter is provided to allow several pulses to be
      defined before the new pulse train is made thus saving
      execution time.
    A / D         Channel                           B / }         Pulse Train Period                CL rw         Pulse Width                       C w         Pulse Delay                       Df A           Instrument ID                     F         Error                             I r }         Baseline                          J] .w         Pulse Level                       J .         Pulse Number                      Kt  }          Number of Pulses                  K  	        Make                                          1 0 2 1 3 2 4 3    100e-6    50e-6    0    1    	            0    5            
   *1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9 10 10    2               No 0 Yes 1          
  Description:    This function is used to verify the existance
                  of a particular arbitrary waveform and to find 
                  its length (number of points).             
    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.        
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
 
      100 to 199 are instrument execution errors
            see the instrument instruction manual
            for details.

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out
     G    
 Description:   The arb name to search for

 Variable Type: String

        
 Description:   Returns the result of the search
                If the value is zero the arb does not exist.
                A non-zero value indicates that the arb exists
                and the actual value is the length in points.

 Variable Type: Integer

    Q6  !           Instrument ID                     Sx          Error                             UF I          Arb Name                          U I          Length                             1    	            "wv01"    	                  
  Description:    Create a new arbitrary waveform of the
                  specified length either as a blank or a copy
                  of an existing waveform.     F    
 Description:   The name for the new arb.

 Variable Type: String

    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    A    
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Create value out of range
       -3   Length value out of range
       -4   Waveforn to copy value out of range

      100 to 199 are instrument execution errors
            see the instrument instruction manual
            for details.

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out
         
 Description:   Create a blank arb or a copy.

 Variable Type: Integer

 Valid Range:   0 = Blank
                1 = Copy

 Default Value: 0 - Blank


         
 Description:   The length, in points, for the new arb.

 Variable Type: Integer

 Valid Range:   4 to 65536

 Default Value: 1024

        
 Description:   Specifies the waveform to use for the copy
                function.

 Variable Type: Integer

 Valid Range:   0 = Sine
                1 = Square
                2 = Triangle
                3 = DC
                4 = Positive Ramp
                5 = Negative Ramp
                6 = Cosine
                7 = Haversine 
                8 = Havercos
                9 = Sync
               10 = ARB

 Default Value: 0 - Sine     x    
 Description:   The arb to use if the waveform to copy is set
                to 10 - arb. 

 Variable Type: String

    XO N a         New arb name                      X             Instrument ID                     Z          Error                             ]( L         Create                            ] LM          Length                            ^Z  `         Waveform to copy                  `! M         Arbitrary name                     "wv01"    1    	                       Blank 0 Copy 1    1024               Siine 0 Square 1 Triangle 2 DC 3 Positive ramp 4 Negative ramp 5 Cosine 6 Haversine 7 Havercosine 8 Sin(x)/x 9 Arbitrary waveform 10    ""    b      
  Description:    Allows an existing arb to be renamed, resized
                  or deleted.     J    
 Description:   The name of the arb to modify

 Variable Type: String

        
 Description:   Selects the modify operation to perform. 

 Variable Type: Integer

 Valid Range:   0 = Delete
                1 = Rename
                2 = Resize
                3 = Channel del

 Default Value: 0 - Delete

 Note: Channel del removes the arb from the current channel
       memory. Delete can only be used after the arb has been 
       removed from all channels.
       Channel del cannot be used to remove the arb currently
       being played back or any arb if the channel is playing
       a waveform sequence.

         
 Description:   The new length for the resize operation. 

 Variable Type: Integer

 Valid Range:   4 to 65536

 Default Value: 1024


     T    
 Description:   The new name for the rename operation. 

 Variable Type: String

    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.        
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Operation value out of range
       -3   Newlength value out of range
 
      100 to 199 are instrument execution errors
            see the instrument instruction manual
            for details.

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out
    cY ] ]         Arb name                          c ]         Operation                         e P          New length                        f` ]P         New arb name                      f
            Instrument ID                     h         Error                              "wv01"               )Delete 0 Rename 1 Resize 2 Channel del 3    1024    ""    1    	            o      
  Description:    Allows the specified arb to be edited by the 
                  selected edit operation.     I    
 Description:   The name of the arb to edit.

 Variable Type: String

        
 Description:   Selects the edit operation to perform. 

 Variable Type: Integer

 Valid Range:   0 = Point edit
                1 = Line draw
                2 = Wave insert
                3 = Block copy
                4 = Wave amplitude
                5 = Wave offset
                6 = Wave invert
                7 = Set position marker
                8 = Del all position markers

 Default Value: 0 - Point edit

    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.        
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Operation value out of range
       -3   Newlength value out of range
 
      100 to 199 are instrument execution errors
            see the instrument instruction manual
            for details.

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out
    t    
 Description:   Set the address index for the first edit point. 

 Variable Type: Integer

 Valid Range:   0 to Second point index - 4

 Default Value: 0

 Note: The first and second point index specify the point 
       addresses between which the edit operation will act.
       For point edit and set position marker only the first     
       point index is used.

        
 Description:   Set the address index for the second edit point. 

 Variable Type: Integer

 Valid Range:   First point index +4 to last waveform point

 Default Value: 0

 Note: The first and second point index specify the point 
       addresses between which the edit operation will act.
       For point edit and set position marker only the first     
       point index is used.

    ^    
 Description:   Set the value for the first edit point. 

 Variable Type: Integer

 Valid Range:   -2048 to 2047

 Default Value: 0

 Note: The first and second point index specify the point 
       addresses between which the edit operation will act.
       For point edit and set position marker only the first     
       point index is used.

    _    
 Description:   Set the value for the second edit point. 

 Variable Type: Integer

 Valid Range:   -2048 to 2047

 Default Value: 0

 Note: The first and second point index specify the point 
       addresses between which the edit operation will act.
       For point edit and set position marker only the first     
       point index is used.

         
 Description:   Set the value for the destinationstart point
                of a block copy operation. 

 Variable Type: Integer

 Valid Range:   0 to last waveform point

 Default Value: 0

         
 Description:   Set the multiplier fo the wave amplitude 
                operation. 

 Variable Type: Float

 Valid Range:   0.1 to 100.0

 Default Value: 1.0

         
 Description:   Set the value for the wave offset operation. 

 Variable Type: Integer

 Valid Range:   -4096 to 4095

 Default Value: 0

        
 Description:   Specifies the waveform to use for the insert
                operation.

 Variable Type: Integer

 Valid Range:   0 = Sine
                1 = Square
                2 = Triangle
                3 = DC
                4 = Positive Ramp
                5 = Negative Ramp
                6 = Cosine
                7 = Haversine 
                8 = Havercos
                9 = Sync
               10 = ARB

 Default Value: 0 - Sine         
 Description:   The arb name for the insert operation when the
                Waveform to insert is set to arb. 

 Variable Type: String

    m4 '          Arb name                          m '          Operation                         o7            Instrument ID                     qy         Error                             s '          First point idx                   u a          Second point idx                  v '          First point value                 x `          Second point value                yo           Destination idx                   z:          Amplitude multiplier              z  	         Offset value                      {{   
        Waveform to insert                }E          Insert arb                         "wv01"            	   Point edit 0 Line draw 1 Wave insert 2 Block copy 3 Wave amplitude 4 Wave offset 5 Wave invert 6 Set position mkr 7 Del all posn mkrs 8    1    	            0    0    0    0    0    1.0    0               Siine 0 Square 1 Triangle 2 DC 3 Positive ramp 4 Negative ramp 5 Cosine 6 Haversine 7 Havercosine 8 Sin(x)/x 9 Arbitrary waveform 10    ""    ]    
 Description:   Sets the Waveform playback mode for the selected 
                channel.    (    
 Description:   Selects the channel to configure.

 Variable Type: Integer

 Valid Range:   0 =  CH1
                1 =  CH2
                2 =  CH3
                3 =  CH4

 Default Value: 0 - CH1

 Note. The instrument will ganerate an error if the selected
       channel is not present.         
 Description:   Specifies the mode.

 Variable Type: Integer

 Valid Range:   0 = Continuous
                1 = Gated
                2 = Triggered
                3 = Sweep
                4 = Tone

 Default Value: 0 - Continuous    -    
 Description:   Specifies Trigger source for Gates, Triggered
                and Tone modes.

 Variable Type: Integer

 Valid Range:   0 = Internal
                1 = External
                2 = Manual
                3 = Previous chan
                4 = Next chan

 Default Value: 0 - Internal         
 Description:   Sets the period of the internal trigger
                generator in seconds

 Variable Type: double

 Valid Range:   10us to 200s

 Default Value: 1e-3 (1ms)         
 Description:   The Burst count expressed in complete cycles of 
                the waveform. Used in triggered and gated modes.

 Variable Type: Integer

 Valid Range:   1 to 1048575

 Default Value: 1         
 Description:   Set the Trigger slope.

 Variable Type: Integer

 Valid Range:   0 =  Positive
                1 =  Negative

 Default Value: 0 - positive        
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Mode value out of range
       -3   Trigger source value out of range
       -4   Frequency value out of range
       -5   Burst count value out of range
       -10  Channel value out of range

      100 to 199 are instrument execution errors
            see the instrument instruction manual
            for details.

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out
    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         
 Description:   Specifies the start (and stop) phase for 
                triggered and gated modes expressed in degrees.

 Variable Type: float

 Valid Range:   -360 to +360 but dependent on selected waveform

 Default Value: 0    b 6 ,         Channel                            8           Mode                               8-         Trigger source                               Internal period                   r <x          Burst count                       H *         Trigger slope                              Error                                         Instrument ID                      }w         Phase angle                                   1 0 2 1 3 2 4 3               0Continuous 0 Gated 1 Triggered 2 Sweep 3 Tone 4               7Internal 0 External 1 Manual 2 Prev chan 3 Next chan 4    1e-3    1               Positive 0 Negative 1    	            1    0    ~    
 Description:   Sets output, sync out, trigger out, waveform
                filter and hold mode for the selected channel.        
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Output value out of range
       -3   Sync out value out of range
       -4   Sync out signal value out of range
       -5   Output filter value out of range
       -6   Trigger out signal value out of range
       -7   Hold value out of range
       -10  Channel value out of range

      100 to 199 are instrument execution errors
            see the instrument instruction manual
            for details.

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out
    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    (    
 Description:   Selects the channel to configure.

 Variable Type: Integer

 Valid Range:   0 =  CH1
                1 =  CH2
                2 =  CH3
                3 =  CH4

 Default Value: 0 - CH1

 Note. The instrument will ganerate an error if the selected
       channel is not present.         
 Description:   Turns the Main output on or off.

 Variable Type: Integer

 Valid Range:   1 = On
                0 = Off

 Default Value: 1 - On         
 Description:   Turns the Sync output on or off.

 Variable Type: Integer

 Valid Range:   1 = On
                0 = Off

 Default Value: 1 - On    e    
 Description:   Sets the sync output signal source.

 Variable Type: Integer

 Valid Range:   0 = Auto
                1 = Waveform sync
                2 = Position markers
                3 = Burst done
                4 = Sequence sync
                5 = Trigger
                6 = Sweep sync
                7 = Phase lock

 Default Value: 0 - Auto         
 Description:   Sets the waveform filter.

 Variable Type: Integer

 Valid Range:   0 = Auto
                1 = 10MHz eliptic
                2 = 16MHz eliptic
                3 = 10MHz bessel
                4 = None

 Default Value: 0 - Auto    
    
 Description:   Sets the trigger out signal source.

 Variable Type: Integer

 Valid Range:   0 = Auto
                1 = Waveform end
                2 = Position markers
                3 = Sequence sync
                4 = Burst done

 Default Value: 0 - Auto         
 Description:   Controls the hold function.

 Variable Type: Integer

 Valid Range:   0 = Enable
                1 = Disable
                2 = On
                3 = Off

 Default Value: 1 - Disable             Error                                         Instrument ID                     = $ "         Channel                           m $ W          Output                            	 $           Sync out                           a          Sync out signal                    $T         Output filter                      $         Trigger out                       #          Hold                               	            1               1 0 2 1 3 2 4 3    On 1 Off 0    On 1 Off 0               cAuto 0 Wfm sync 1 Position mkrs 2 Burst done 3 Sequence sync 4 Trigger 5 Sweep sync 6 Phase lock 7               =Auto 0 Eliptic 10MHz 1 Eliptic 16MHz 2 Bessel 10MHz 3 None 4               >Auto 0 Wfm end 1 Position mkrs 2 Sequence sync 3 Burst done 4              Enable 1 Disable 0 On 2 Off 3        
 Description:   Sets the global sweep parameters.

       The sweep parameters are common to all channels but each
       channel may be set to sweep independantly.        
 Description:   Selects the channel to set sweep on or off.

 Variable Type: Integer

 Valid Range:   0 =  CH1
                1 =  CH2
                2 =  CH3
                3 =  CH4

 Default Value: 0 - CH1

 Note. The instrument will ganerate an error if the selected
       channel is not present.

       The sweep parameters are common to all channels but each
       channel may be set to sweep independantly.        
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Control value out of range
       -3   Sweep type value out of range
       -4   Direction value out of range
       -5   Spacing value out of range
       -6   Sync value out of range
       -10  Channel value out of range

      100 to 199 are instrument execution errors
            see the instrument instruction manual
            for details.

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out
    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         
 Description:   Sets the type of sweep.

 Variable Type: Integer

 Valid Range:   0 = Continuous
                1 = Triggered
                2 = Triggered hold and reset

 Default Value: 0 - Continuous         
 Description:   Set the sweep direction.

 Variable Type: Integer

 Valid Range:   0 = Up
                1 = Down
                2 = Up-down
                3 = Down-up

 Default Value: 0 - Up         
 Description:   Controls the sweep spacing.

 Variable Type: Integer

 Valid Range:   0 = Linear
                1 = Logarithmic
                3 = Off

 Default Value: 0 - Linear         
 Description:   Set the sweep start frequency in Hz.

 Variable Type: Float

 Valid Range:   0.1 to 16e6

 Default Value: 1000         
 Description:   Set the sweep stop frequency in Hz.

 Variable Type: Float

 Valid Range:   0.1 to 16e6

 Default Value: 10000         
 Description:   Set sync sweep start o on or off.

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On

 Default Value: 0 - Off         
 Description:   Set the sweep marker frequency in Hz.

 Variable Type: Float

 Valid Range:   0.1 to 16e6

 Default Value: 5000         
 Description:   Turns the sweep on or off.

 Variable Type: Integer

 Valid Range:   1 = On
                0 = Off

 Default Value: 0 - Off               Channel                                    Error                             l! 
           Instrument ID                      b e         Sweep type                          h         Direction                         Q  j         Spacing                            b          Start frequency                    bY         Stop frequency                    "            Sync                             X         Duration                           Y 	        Marker frequency                  J  + 
         Control                                       1 0 2 1 3 2 4 3    	            1               +Continuous 0 Triggered 1 Trig hold reset 2                Up 0 Down 1 Up down 2 Down up 3               Linear 0 Logarithmic 1    1000.0    10000.0    On 1 Off 0    1.0    5000.0    On 1 Off 0          
  Description:    Set the parameters for each sequence step on
                  the selected channel.
                  To run the sequence select it as the function
                  in the configure waveform window.    (    
 Description:   Selects the channel to configure.

 Variable Type: Integer

 Valid Range:   0 =  CH1
                1 =  CH2
                2 =  CH3
                3 =  CH4

 Default Value: 0 - CH1

 Note. The instrument will ganerate an error if the selected
       channel is not present.    b    
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Segment no. out of range
       -3   Seg status value out of range
       -4   Step on value out of range
       -10  Channel value out of range

      100 to 199 are instrument execution errors
            see the instrument instruction manual
            for details.

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out
    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.     ~    
 Description:   Selects the segment number to edit. 

 Variable Type: Integer

 Valid Range:   1 to 16

 Default Value: 1

         
 Description:   Specifies the arb waveform name for the segment.

 Variable Type: String

 Valid Range:   Must be an existing arb waveform.

 Default Value: wv01

    )    
 Description:   Set the status of the current segment. 

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On

 Default Value: 0 - Off

 Note: Setting status off will also set all segments above to 
       off.
       Setting status on will also set all segments below to on.     n    
 Description:   The count value. 

 Variable Type: Integer

 Valid Range:   1 to 32767

 Default Value: 1

         
 Description:   Selects the step specification for the segment. 

 Variable Type: Integer

 Valid Range:   0 = Count
                1 = Trigger edge
                2 = Trigger level

 Default Value: 0 - Count

    E , G         Channel                           u         Error                                         Instrument ID                     ! 3          Segment no.                        t          Arb wfm name                      U .          Seg status                                    Count                              )         Step on                                       1 0 2 1 3 2 4 3    	            1               N1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9 10 10 11 11 12 12 13 13 14 14 15 15 16 16    "wv01"    On 1 Off 0    1               "Count 0 Trig edge 1 Trig level  2    g      
  Description:    Set the frequencies for the tone list on the
                  selected channel.        
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Tone type value out of range
       -3   Tone number value out of range
       -4   Frequency value out of range
       -5   DC offset value out of range
       -6   Freq/per value out of range
       -8   Zout value out of range
       -9   Sense value out of range
       -10  Channel value out of range

      100 to 199 are instrument execution errors
            see the instrument instruction manual
            for details.

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out
    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.     {    
 Description:   Selects the tone number to edit. 

 Variable Type: Integer

 Valid Range:   1 to 16

 Default Value: 1

         
 Description:   The tone frequency expressed in Hz.

 Variable Type: float

 Valid Range:   1e-4 to 10e6

 Default Value: 1000         
 Description:   Selects type of switching between tones. 

 Variable Type: Integer

 Valid Range:   0 = Gate
                1 = Trig
                2 = FSK

 Default Value: 0 - Gate
    (    
 Description:   Selects the channel to configure.

 Variable Type: Integer

 Valid Range:   0 =  CH1
                1 =  CH2
                2 =  CH3
                3 =  CH4

 Default Value: 0 - CH1

 Note. The instrument will ganerate an error if the selected
       channel is not present.             Error                             !            Instrument ID                      ^           Tone number                       Ý ^l         Tone frequency                    & ^          Tone type                          ] O         Channel                            	            1    1    1000.0               Gate 0 Trig 1 FSK 2               1 0 2 1 3 2 4 3    D      
  Description:    Set the modulation for the selected channel..    (    
 Description:   Selects the channel to configure.

 Variable Type: Integer

 Valid Range:   0 =  CH1
                1 =  CH2
                2 =  CH3
                3 =  CH4

 Default Value: 0 - CH1

 Note. The instrument will ganerate an error if the selected
       channel is not present.    6    
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Source value out of range
       -3   Type value out of range
       -10  Channel value out of range

      100 to 199 are instrument execution errors
            see the instrument instruction manual
            for details.

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out
    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         
 Description:   Selects the modulation source. 

 Variable Type: Integer

 Valid Range:   0 = Off
                2 = External
                3 = Previous channel

 Default Value: 0 - Off

         
 Description:   Selects the type of modulation. 

 Variable Type: Integer

 Valid Range:   0 = AM/VCA
                1 = SCM
 
 Default Value: 0 - AM/VCA

         
 Description:   Selects the level of modulation in Vp-p if 
                the type is set to SCM and the source is set 
                to previous channel. 

 Variable Type: Float

 Valid Range:   0 to 10

 Default Value: 5

         
 Description:   Selects the percentage depth of modulation if 
                the type is  set to AM and the source is set to
                previous channel. 

 Variable Type: Float

 Valid Range:   0 to 105

 Default Value: 30

     - 0         Channel                           5         Error                             s!            Instrument ID                     ͵ ?         Source                            ~           Type                              %          SCM level                                   AM depth                                      1 0 2 1 3 2 4 3    	            1               Off 0 External 1 Prev chan 2               AM/VCA 0 SCM 1    5.0    30.0    A      
  Description:    Set the summing for the selected channel..    (    
 Description:   Selects the channel to configure.

 Variable Type: Integer

 Valid Range:   0 =  CH1
                1 =  CH2
                2 =  CH3
                3 =  CH4

 Default Value: 0 - CH1

 Note. The instrument will ganerate an error if the selected
       channel is not present.         
 Description:   Selects the summing source.

 Variable Type: Integer

 Valid Range:   0 = Off
                2 = External
                3 = Previous channel

 Default Value: 0 - Off

    =    
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Source value out of range
       -3   Attenuation value out of range
       -10  Channel value out of range

      100 to 199 are instrument execution errors
            see the instrument instruction manual
            for details.

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out
    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         
 Description:   Selects the summing ratio if the source is set
                to previous channel. 

 Variable Type: Float

 Valid Range:   Amplitude dependent

 Default Value: 1.00

    '    
 Description:   Selects the attenuation applied to external
                summing signals.

 Variable Type: Float

 Valid Range:   0 = 0dB
                1 = 10dB
                2 = 20dB
                3 = 30dB
                4 = 40dB
                5 = 50dB

 Default Value: 0 - 0dB

    L . 3         Channel                           | @         Source                            A         Error                             ׆"            Instrument ID                                Ratio                             ڋ           Attenuator                                    1 0 2 1 3 2 4 3               Off 0 External 1 Prev chan 2    	            1    1.0               )0dB 0 10dB 1 20dB 2 30dB 3 40dB 4 50dB 5          
  Description:    Sets the inter channel phase locking mode and 
                  phase angle for the selected channel and 
                  allows the setting of the instrument locking 
                  status.    (    
 Description:   Selects the channel to configure.

 Variable Type: Integer

 Valid Range:   0 =  CH1
                1 =  CH2
                2 =  CH3
                3 =  CH4

 Default Value: 0 - CH1

 Note. The instrument will ganerate an error if the selected
       channel is not present.    6    
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Mode value out of range
       -3   Status value out of range
       -10  Channel value out of range

      100 to 199 are instrument execution errors
            see the instrument instruction manual
            for details.

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out
    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         
 Description:   Sets the locking mode. 

 Variable Type: Integer

 Valid Range:   0 = Independent
                2 = Master
                3 = Master with frequency tracking
                4 = Slave

 Default Value: 0 - Independent

         
 Description:   Specifies the lock phase angle expressed in 
                degrees.

 Variable Type: float

 Valid Range:   -360 to +360 but dependent on selected waveform

 Default Value: 0         
 Description:   Sets the instrument locking status

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On
 
 Default Value: 0 - Off

    v , 3         Channel                           ߦ         Error                                          Instrument ID                     & 2         Mode                                         Phase angle                         )          Status                                        1 0 2 1 3 2 4 3    	            1               ,Indepeedent 0 Master 1 Master/freq 2 Save 3    0.0    On 1 Off 0       
Description:    Specify the way in which status is
                reported and Service Request is
                generated as defined in the IEEE
                488.2 standard.

                The function provides access to
                the three status enable registers
                in the TG1010, these are:

                Service Request Enable Register
                - Specifies which bits, when set,
                  in the Status Byte register will
                  generate a Service Request.

                Standard Event Enable Register
                - Specifies which bits, when set,
                  in the Standard Event Status
                  register will set the ESB bit in
                  the Status Byte Register.


                Parallel Poll Enable Register
                - Specifies which bits, when set,
                  in the Status Byte register will
                  be used to form the ist local
                  message

                See the IEEE 488.2 Standard and
                the instrument  instruction book
                for a full description of status
                reporting capabilities.        
Description:    Used to select which enable
                register will receive the byte
                value.

Variable type:  integer

Valid range:    0 = SRQ enable
                1 = Standard Event Enable
                2 = Parallel Poll

Default value   0 - SRQ Enable
         
Description:    A byte value which will be written
                to the selected enable register.

Variable type:  integer

Valid range:    0 to 255

Default value:  0
    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Status Enable value out of range
       -3   Register Value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out     ]           Set Status Enable                  ]          Value                                          Instrument ID                               Error                                         +SRQ enable 0 Event Enable 1 Parallel Pol 2    0    1    	               
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Start point is greater then End point
       -3   Arb does not exist.
       -4   End point is past end of waveform
       -5   No of points exceeds 32768
      -10   Channel value out of range

      100 to 199 are instrument execution errors
            see the instrument instruction manual
            for details.

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      240   Instrument timed out
    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         
 Description:   Specifies the arb waveform name to
                use when the function is set to Arb.

 Variable Type: String

 Valid Range:   Must be an existing arb waveform.

 Default Value: wv01

    ~    
 Description:   Receives the point data read from the arb
                waveform. There must be enough elements in
                the array to hold all the point data.
                The data in the array will range between 0 and
                4095. This array may be used as the input for
                the Write arb data function.

 Variable Type: Short integer array

             Error                             ) 
           Instrument ID                      E          Arb wfm name                                Start                                       End                                A  
       Wfm data array                     	            1    "wv01"    0    1023    	                
 Description:   Specifies the arb waveform name to
                use when the function is set to Arb.

 Variable Type: String

 Valid Range:   Must be an existing arb waveform.

 Default Value: wv01

        
 Description:   Contains the point data to send to the arb
                waveform. There must be enough elements in
                the array to hold at least the length 
                required between the start and stop points.
                The data in the array will range between 0 and
                4095. e.g. an array already filled by the Read
                arb data function.

 Variable Type: Short integer array

        
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Start point is greater then End point
       -3   Arb does not exist.
       -4   End point is past end of waveform
       -5   No of points exceeds 32768
       -10  Channel value out of range

      100 to 199 are instrument execution errors
            see the instrument instruction manual
            for details.

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      240   Instrument timed out
    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.     8          Arb wfm name                     u           Start                             ~ C  
       Wfm data array                              End                               9         Error                                        Instrument ID                      "wv01"    0    	            1023    	            1        
Description:    Stores or Recalls the complete
                state of the instrument to or from
                local non-volatile memory.         
 Description:   Selects the recall or store
                operation.

 Variable Type: Integer

 Valid Range:   0 = Recall
                1 = Store

 Default Value: 0 - Recall         
Description:    Select the number of the store to
                Recall from or Store to.

Variable type:  integer

Valid range:    1 to 9

Default value:  1

    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    l    
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Operation value out of range
       -3   Store Number out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out   R ]           Operation                         ]          Store Number                                  Instrument ID                    	          Error                                         Recall 0 Store 1    1    1    	            \    
Description:    Returns the byte value from the
                selected status register.    l    
Description:    Used to select which status
                register to read

Variable type:  integer

Valid range:    0 = Status Byte
                1 = Standard Event Status
                2 = SRQ enable
                3 = Standard Event Enable
                4 = Parallel Poll Enable
                5 = Execution Error

Default value   0 - Status Byte

     n    
Description:    Returns the value read from the
                selected register.

Variable type:  integer    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.        
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Status Enable value out of range
       -3   Register Value out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      240   Instrument timed out    ]           Read Status                      Q ]          Value                                         Instrument ID                    	          Error                                         SStatus byte 0 Std Event 1 SRQ enable 2 Event Enable 3 Parallel Pol 4 Exeq. error 5    	            1    	            d    
Description:    Sends a string of bytes to the
                instrument from a string variable.         
Description:    This control specifies data to be
                sent to the instrument. The absolute
                maximum length allowed is 200
                bytes.

Variable type:  String    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.        
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    ]          Command                          m             Instrument ID                              Error                                  1    	            _    
Description:    Reads a response from the instrument
                into a string variable.        
Description:    This control specifies a string
                variable to receive the response
                from the instrument. The string must
                be long enough to receive the
                response to avoid overflow. To aid
                in checking this the number of
                bytes put into the string is
                returned from the function. The
                absolute maximum length allowed is
                2000 bytes.

Variable type:  String         
Description:    This value is the number of bytes
                returned by the instrument and
                placed in the string.

Variable type:  Integer    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.        
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range

      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out    ]          Response                          ]          Number Of Bytes                               Instrument ID                              Error                              	            	            1    	                
Description:    Send or Receive a binary block to
                or from the instrument. The data will
                be read from or written to a file.

Note            This operation is usefull for
                LRN blocks.         
 Description:   Selects to send a file to the
                instrument or Get a file from instrument.

 Variable Type: Integer

 Valid Range:   0 = Send file to instrument
                1 = Get file from instrument

 Default Value: 0 - Send file         
Description:    This control specifies file name
                from which the binary block will
                be sent to the instrument.

Variable type:  String - max length 50 characters    :    
 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.        
 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Operation value out of range

      228   Error writing to instrument from file
      229   Error reading from instrument to file
      232   Instrument not initialized
      240   Instrument timed out   ! ]           Operation                        " ]         File Name                        #             Instrument ID                    %          Error                                         Send File 0 Get File 1        1    	                 Panel Name:    Close

 Description:   Closes the instrument and takes it
                off line.

 Note: The  instrument must  be reinitialized
       to use it again.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      221   Unable to close instrument
      232   Instrument not initialized   )@             Instrument ID                    +          Error                              1    	                    !     K.    init                                     #  3     B%    config_wfm                               7  ?     K.    config_pulse                             A  Mx     K.    config_pulse_trn                         Pi  V     K.    arb_info                                 W  `     I*    arb_create                               b  k     K.    arb_modify                               l  } 
    K.    arb_edit                                    	    K.    setup_mode                                  	    K.    setup_conector                           W       K.    setup_sweep                              ^       K.    setup_seq                                ^       K.    setup_tone                               ǹ       K.    setup_mod                                  ۺ     K.    setup_sum                                ݓ       K.    set_inter                                H       K.    set_status                               7     K.    arb_read                                I     K.    arb_write                                o     K.    loc_stores                              y      K.    get_status                              3      K.    snd_cmd                                       K.    get_resp                                  '}     K.    file_ops                                ( ,     K.    close                                                                       DInitialize                          Configure                            DWaveform                            aStd Waveform Setup                   DPulse Setup                          DPulse Train Setup                    Arb Waveform Setup                   DArb Info                             DCreate New Arb                       DModify Arb                           DEdit Arb                             DMode setup                           DConnector setup                      DSweep setup                          DSequence Setup                       DTone setup                           DModulation setup                     DSum setup                            DInter Channel setup                  DSet Status                          Data functions                       DRead Arb Data                        DWrite Arb Data                       DLocal Storage                        DGet Status                          pMiscellaneous                        DSend command string                  DGet Response string                  DFile operations                      DClose                           